unit UDemoActiveX;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, OleServer, MRVW_TLB;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Bevel1: TBevel;
    ProgressBar: TProgressBar;
    Panel1: TPanel;
    Label6: TLabel;
    MRViewerObject: TMRViewerObject;
    RGType: TRadioGroup;
    RGReport: TRadioGroup;
    procedure Button1Click(Sender: TObject);
    procedure MRViewerObjectProgress(Sender: TObject; Position: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.Button1Click(Sender: TObject);
begin
    try
        if RGType.ItemIndex = 0 then
        begin
           case RGReport.ItemIndex of
             0: MRViewerObject.LoadReport('..\..\Reports\DemoGraph1.mrp');
             1: MRViewerObject.LoadReport('..\..\Reports\DemoGraph2.mrp');
             2: MRViewerObject.LoadReport('..\..\Reports\DemoGraph3.mrp');
           end;
        end
        else
        begin
           case RGReport.ItemIndex of
             0: MRViewerObject.LoadReport('..\..\Reports\Demo1.mrp');
             1: MRViewerObject.LoadReport('..\..\Reports\Demo2.mrp');
             2: MRViewerObject.LoadReport('..\..\Reports\Demo3.mrp');
           end;
        end;

        MRViewerObject.PreviewReport;
    finally
        MRViewerObject.UnLoadReport;
    end;
end;

procedure TForm1.MRViewerObjectProgress(Sender: TObject;
  Position: Integer);
begin
    ProgressBar.Position := Position;
end;

end.
